<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password Success | OMIGA IPL</title>
    <link rel="icon" href="{{asset('/assets')}}/images/favicon.ico" type="image/x-icon">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/bootstrap/5.3.2/bootstrap.min.css">

    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{asset('/assets')}}/css/icons/fontawesome/css/fontawesome.css">
    <link rel="stylesheet"  href="{{asset('/assets')}}/css/icons/fontawesome/css/brands.css">
    <link rel="stylesheet"  href="{{asset('/assets')}}/css/icons/fontawesome/css/regular.css">
    <link rel="stylesheet"  href="{{asset('/assets')}}/css/icons/fontawesome/css/solid.css">
    
     <!-- Page CSS -->
    <link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/style.css">
    <link rel="stylesheet" type="text/css" href="{{asset('/assets')}}/css/authentication.css">

    <style>
        .logo-widget{
            background:#D4EFFF;
            background-size: cover !important;
        }
    </style>

</head>
<body>
<div class="page-content overflow-hidden min-vh-100 reset-pwd-container">
   <div class="row g-0 vh-100">
      <div class="col-xl-5 col-lg-5 col-md-6 col-sm-6 rightside-widget-col">
         <div class="p-lg-5 p-4 h-100 logo-widget">
            <div class="d-flex justify-content-center align-items-center h-100">
               <div class="">
                  <img src="{{asset('/assets')}}/images/login-frame.svg" style="height:400px;" class="inframe-logo" alt="logo frame"> 
               </div>
            </div>
         </div>
      </div>
      <div class="col-xl-7 col-lg-7 col-md-6 col-sm-6 d-flex justify-content-center align-items-center">
          <div class="row">
               <div class="msg-container text-center">
                  <img src="{{asset('/assets')}}/images/icons/check.png" style="height:130px;" class="check-icon" alt="Check Icon"> 
                  <h5 class="text-success mt-4">Your password has been changed Successfully!</h5>
               </div>
             
             
          </div>
      </div>
   </div>
</div>




<!-- ====================================================================================================== -->
    
    <!-- Page JS -->
    <script type="text/javascript" src="{{asset('/assets')}}/js/authentication.js"></script>
    <script type="text/javascript" src="{{asset('/assets')}}/js/bootstrap/5.3.2/bootstrap.min.js"></script>

<!-- ====================================================================================================== -->   



<!-- Validation JS -->
<script>
document.getElementById('password').addEventListener('input', function() {
    const password = this.value;
    const pwdCondition = document.getElementById('pwd-condition');
    const specialCharacterPattern = /[!@#$%^&*(),.?":{}|<>]/;
    const allInputs = document.querySelectorAll('input');

    if (password.length >= 8 && specialCharacterPattern.test(password)) {
        pwdCondition.classList.remove('text-danger');
        pwdCondition.classList.add('text-success');
        pwdCondition.classList.add('bounce-zoom');
        pwdCondition.style.opacity = '0'; 
        pwdCondition.style.height = '0';
        allInputs.forEach(input => {
            if (input.id !== 'password') {
                input.disabled = false; 
            }
        });
    } else {
        pwdCondition.classList.remove('text-success');
        pwdCondition.classList.add('text-danger');
        pwdCondition.style.opacity = '1'; 
        pwdCondition.style.height = 'auto';
        allInputs.forEach(input => {
            if (input.id !== 'password') {
                input.disabled = true; 
            }
        });
        
        pwdCondition.classList.add('shake'); 
        setTimeout(() => {
            pwdCondition.classList.remove('shake'); 
        }, 500); 
    }
});
</script>




</body>
</html>