<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_subscriptions', function (Blueprint $table) {
            $table->id();
            $table->string('user_id');
            $table->string('name');
            $table->string('membership_id');
            $table->string('transaction_id')->unique();
            $table->text('payment_image');
            $table->string('title');
            $table->float('amount',15,2)->default(0);
            $table->integer('days')->nullable();
            $table->enum('type',['admin','user']);
            $table->string('remark')->nullable();
            $table->timestamp('action_at')->nullable();
            $table->enum('status',['Requested','Rejected','Accepted']);
            $table->boolean('is_active',[0,1])->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_subscriptions');
    }
};
