<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\BannerImage;
use Illuminate\Http\Request;
use App\Models\Notification;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;

use App\Models\DeliveryFeeMaster;

class DashboardController extends Controller
{
   

    public function notification_post(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'notification_title' => 'required|string|max:255',
            'description'        => 'required|string',
        ]);
        if ($validator->fails()) {

            return redirect()->back()->withErrors($validator)->withInput();
            
        }
        $notification              = new Notification();
        $notification->title       = $request->input('notification_title');
        $notification->description = $request->input('description');
        $notification->save();
        return redirect()->route('notification')->with('successmessage', 'Notification added successfully.');
    }

    public function delivery_price_page()
    {
        $deliveries = DeliveryFeeMaster::all(); 
        return view('admin.delivery_price', compact('deliveries'));
    }
    public function delivery_fee_post(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'town'         => 'required|string|max:255',
            'add_area'     => 'required|string|max:255|unique:delivery_fee_masters,area',
            'delivery_fee' => 'required|numeric|min:0',
        ], [
            'add_area.unique' => 'The area already exists in the database. Please choose a different area.',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        }
        $deliveryFeeMaster               = new DeliveryFeeMaster();
        $deliveryFeeMaster->town         = $request->town;
        $deliveryFeeMaster->area         = $request->add_area;
        $deliveryFeeMaster->delivery_fee = $request->delivery_fee;
        $deliveryFeeMaster->save();
        return redirect()->route('delivery_fee')->with('successmessage', 'Delivery fee added successfully.');
    }
    public function delivery_fee_delete($id)
    {
        $delivery = DeliveryFeeMaster::find($id);
        if ($delivery) {
            $delivery->delete();
            return redirect()->back()->with('successmessage', 'Delivery fee deleted successfully.');
        }
        return redirect()->back()->with('errormessage', 'Delivery fee not found.');
    }


    public function banner_delete($id)
    {
        $banner = BannerImage::find($id);
        if ($banner) {

            if (file_exists(public_path('images/banner/' . $banner->banner_image))) {
                unlink(public_path('images/banner/' . $banner->banner_image));
            }
            $banner->delete();
            return redirect()->back()->with('successmessage', 'Banner deleted successfully.');
        }
        return redirect()->back()->with('error', 'Banner not found.');
    }
    public function notification_delete($id)
    {
        $notification = Notification::findOrFail($id);
        if($notification) 
        {
        $notification->delete();
        return redirect()->route('notification')->with('successmessage', 'Notification deleted successfully.');
        }
        return redirect()->back()->with('errormessage','Error not found');
   
    }
    public function delivery_post(Request $request)
{
    $validatedData = $request->validate([
        // 'town'          => 'required|string|max:255',
        // 'add_area'      => 'required|string|max:255|unique:delivery_fee_masters,area',
        'delivery_fee'  => 'required|numeric',
        'price_from'    => 'nullable|numeric',
        'price_to'      => 'nullable|numeric',
       
    ]);

  
    DeliveryFeeMaster::create([
        // 'town'          => $request->town,
        // 'area'          => $request->add_area,
        'delivery_fee'  => $request->delivery_fee,
        'price_from'    => $request->price_from,
        'price_to'      => $request->price_to,
      
    ]);

    return redirect()->route('delivery_price_page')->with('successmessage', 'Delivery Fee added successfully!');
}
public function banner_post(Request $request)
{
    
    $validator = Validator::make($request->all(), [
        'banner_name' => 'required|string|max:255',
        'banner_img'  => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
    ]);
    if ($validator->fails()) {
        return redirect()->back()->withErrors($validator)->withInput();
    }
    
    $imagePath = null;
    if ($request->hasFile('banner_img')) {
        $file = $request->file('banner_img');
        if (!$file->isValid()) {
            return redirect()->back()->with('errormessage', 'File upload failed.');
        }
        $fileName        = time() . '_' . $file->getClientOriginalName();
        $destinationPath = public_path('assets/images/banners');
        $file->move($destinationPath, $fileName);
        $imagePath       = 'assets/images/banners/' . $fileName;
    }

    $banner               = new BannerImage();
    $banner->banner_name  = $request->input('banner_name');
    $banner->banner_image = $imagePath;
    $banner->save();
    return redirect()->back()->with('successmessage', 'Banner added successfully.');
}
}