@extends('admin.layouts')
@section('title', 'Products')

@section('header')

<!-- DataTable CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/datatable/dataTables.bootstrap5.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/datatable/responsive.bootstrap.min.css')}}">
<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/datatable/buttons.dataTables.min.css')}}">

<!-- Page CSS -->
<link rel="stylesheet" type="text/css" href="{{asset('/assets/css/formILY.css')}}">

<!-- Toastr CSS -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">
@endsection

@section('content')

<div class="container-fluid page-wrapper category-container">
    <div class="row">
        <div class="d-flex justify-content-between align-items-center">
            <h3 class="page-top-heading">Products</h3>
            <a type="button" href="{{ route('add_product') }}" class="btn btn-primary feature-btn"><i class="fa-solid fa-circle-plus me-2"></i>Add Product</a>
        </div>
    </div>

    <!-- Table Row -->
    <div class="row mt-5">
        <div class="col-lg-12">
            <div class="card datatable-card">
                <div class="card-body">
                    <table id="data-table" class="table nowrap align-middle" style="width:100%">
                        <thead>
                            <tr>
                                <th>S/N</th>
                                <th>CATEGORY</th>
                                <th>SUB CATEGORY</th>
                                <th>TITLE</th>
                                <th>UNIT</th>
                                <th>PRICE</th>
                                <th>ACTION</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($products as $product)
                            @php
                            $titles = [];
                            $units = [];
                            $prices = [];
                            @endphp
                            @forelse ($product->variants as $variant)
                                @php
                                    $titles[] = $variant->title ? $variant->title : '';
                                    $units[] = $variant->unit ? $variant->unit : '';
                                    $prices[] = $variant->price ? $variant->price : '';
                                @endphp
                            @empty
                            @endforelse
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $product->category->category_name ?? 'N/A' }}</td>
                                <td>{{ $product->subcategory->subcategory_name ?? 'N/A' }}</td>
                                <td>{{ implode(', ', $titles) }}</td> <!-- Display all titles -->
                                <td>{{ implode(', ', $units) }}</td>  <!-- Display all units -->
                                <td>{{ implode(', ', $prices) }}</td> <!-- Display all prices -->
                                <td>
                                    <a href="{{ route('view_product', ['id' => $product->id]) }}" class="btn transparent-btn text-info text-decoration-underline">View</a>
                                    <button type="button" data-bs-toggle="modal" data-bs-target="#DeleteModal-{{ $product->id }}" class="btn transparent-btn text-danger text-decoration-underline">Delete</button>
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <!-- Table Row Ends -->
    @foreach($products as $product)
    <div class="modal fade zoom-in" id="DeleteModal-{{ $product->id }}" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="p-3">
                                <div class="text-center">
                                    <img class="mb-3" src="{{ asset('/assets/images/icons/delete-icon.svg') }}">
                                    <p class="my-4 are-you-sure">Are You Sure?</p>
                                    <p class="text-muted my-2 are-you-sure-subtext">Are you sure you want to delete this product: <strong>{{ $product->title }}</strong>?</p>
                                </div>
                                <div class="d-flex align-items-center mt-5 mb-3">
                                    <button data-bs-dismiss="modal" class="btn btn-light cancel-btn me-3">Cancel</button>
                                    <a href="{{ route('delete_product', ['id' => $product->id]) }}" class="btn btn-primary yes-btn">
                                        <i class="fa-regular fa-circle-check me-2"></i>Yes, Delete It!
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @endforeach
</div>
<!-- end container fluid -->

@endsection

@section('footer')

<!-- JQuery CDN -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<!-- Toastr JS -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

<!-- Datatable JS -->
<script type="text/javascript" src="{{asset('/assets/js/datatable/dataTables.bootstrap5.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/datatables.init.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/dataTables.responsive.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/jquery.dataTables.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/dataTables.buttons.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/buttons.html5.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/buttons.print.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/jszip.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/pdfmake.min.js')}}"></script>
<script type="text/javascript" src="{{asset('/assets/js/datatable/vfs_fonts.js')}}"></script>

<script>
    $(document).ready(function() {
        @if(session('success'))
            toastr.success("{{ session('success') }}");
        @elseif(session('error'))
            toastr.error("{{ session('error') }}");
        @elseif(session('warning'))
            toastr.warning("{{ session('warning') }}");
        @endif
    });
</script>

@endsection
