<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderDetailsResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray($request)
    {
        // return [
        //     'order_id'             => $this->order->id,
        //     'Bill Id'              => $this->order_random_id,
        //     'user_id'              => $this->user_id,
        //     'user_name'            => $this->user_name,
        //     'product_details_id'   => $this->product_details_id,
        //     'product_details_name' => $this->product_details_name,
        //     'category_name'        => $this->category_name,
        //     'subcategory_name'     => $this->subcategory_name,
        //     'quantity'             => $this->quantity,
        //     'amount'               => $this->amount,
        //     'delivery_address'     => $this->delivery_address,
        //     'instruction'          => $this->instruction,
        //     'courier'              => $this->courier,
        //     'tracking_id'          => $this->tracking_id,
        //     'status'               => $this->status,
        //     'order_date'           => $this->order_date,
        // ];
        return [
            'order_id'             => $this->order->id ?? 'N/A',
            'Bill Id'              => $this->order_random_id ?? 'N/A',
            'user_id'              => $this->user_id ?? 'N/A',
            'user_name'            => $this->user->name ?? 'N/A',
            'product_details_id'   => $this->product->id ?? 'N/A',
            'product_details_name' => $this->product->name ?? 'Unknown Product',
            'category_name'        => $this->product->category->name ?? 'N/A',
            'subcategory_name'     => $this->product->subcategory->name ?? 'N/A',
            'quantity'             => $this->quantity ?? 0,
            'amount'               => $this->amount ?? 0,
            'delivery_address'     => $this->delivery_address ?? 'N/A',
            'instruction'          => $this->instruction ?? 'N/A',
            'courier'              => $this->courier ?? 'N/A',
            'tracking_id'          => $this->tracking_id ?? 'N/A',
            'status'               => $this->status ?? 'N/A',
            'order_date'           => $this->order_date ?? 'N/A',
        ];
    }
    }

